//  
//  ZoneEvent.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections;
using System.Text;

namespace LFSLapper
{
    class ZoneEvent
    {
        public int x1, y1, dist;
		public string commandEnter = "";
		public string commandLeave = "";
		public string idTask;
		public ZoneEvent(string pidTask, int px1, int py1, int pdist, string pcommandEnter)
		{
			initZoneEvent(pidTask, px1, py1, pdist, pcommandEnter);
		}
		public ZoneEvent(string pidTask, int px1, int py1, int pdist, string pcommandEnter, string pcommandLeave)
		{
			initZoneEvent( pidTask, px1, py1, pdist, pcommandEnter );
			commandLeave = pcommandLeave;
		}
		private void initZoneEvent(string pidTask, int px1, int py1, int pdist, string pcommandEnter)
		{
			this.idTask = pidTask;
			this.x1 = px1;
			this.y1 = py1;
			this.dist = pdist;

			commandEnter = pcommandEnter;
			commandLeave = "";
		}

	}
    class ListZoneEvent
    {
        System.Collections.Hashtable listOfZones = new System.Collections.Hashtable();

		public void Add(string idTask, string trackName, int x1, int y1, int dist, string commandEnter)
		{
			if (!listOfZones.ContainsKey(trackName))
			{
				listOfZones[trackName] = new ArrayList();
			}
			(listOfZones[trackName] as ArrayList).Add(new ZoneEvent(idTask, x1, y1, dist, commandEnter));
        }
		public void Add(string idTask, string trackName, int x1, int y1, int dist, string commandEnter, string commandLeave)
		{
			if (!listOfZones.ContainsKey(trackName))
			{
				listOfZones[trackName] = new ArrayList();
			}
			(listOfZones[trackName] as ArrayList).Add(new ZoneEvent(idTask, x1, y1, dist, commandEnter,commandLeave));
        }
		public int getMyZone(string trackName, int x, int y)
        {
            if (listOfZones.ContainsKey(trackName))
            {
                ArrayList zones = (ArrayList)listOfZones[trackName];
                for (int i = 0; i < zones.Count; i++)
                {
                    ZoneEvent z = (ZoneEvent)zones[i];
                    int distX = z.x1 - x;
                    int distY = z.y1 - y;
                    int dist = (int)System.Math.Sqrt(distX * distX + distY * distY);
//                    Console.WriteLine(dist);
                    if (dist <= z.dist )
                        return i;
                }
            }
            return -1;
        }
		public string idZoneByIdxZone(string trackName, int idx)
		{
			if (idx == -1)
				return "NONE";
			ArrayList zones = (ArrayList)listOfZones[trackName];
			return (zones[idx] as ZoneEvent).idTask;
		}

        public void Remove(string idTask, string trackName)
        {
            if ((idTask != "") && (trackName != ""))
            {
                if (listOfZones.ContainsKey(trackName))
                {
                    //Get Arraylist with zones
                    ArrayList zones = (ArrayList)listOfZones[trackName];
                    for (int i = zones.Count - 1; i >= 0; i--)
                    {
                        if ((zones[i] as ZoneEvent).idTask == idTask)
                        {
                            //remove zone(ID) from Arraylist
                            zones.RemoveAt(i);
                        }
                    }
                }
            }
        }
        public string getCommandZoneEnter(string trackName, int idx)
		{
            ArrayList zones = (ArrayList)listOfZones[trackName];
            return (zones[idx] as ZoneEvent).commandEnter;
		}

        /* // OLD LeaveZone code
        public string getCommandZoneLeave(string trackName, int idx, string idTask)
        {
            ArrayList zones = (ArrayList)listOfZones[trackName];
            return (zones[idx] as ZoneEvent).commandLeave;
        }
        */

        //LeaveZone code updated @ 13/09/2017
        public string getCommandZoneLeave(string trackName, int idx , string idTask)
        {
            string ReturnValue = "";
            ArrayList zones = (ArrayList)listOfZones[trackName];
            // Check if id value is higher than zonecount. (without this check, Lapper will crash)
            if (idx >= zones.Count)
            {
                ReturnValue = "";
            }
            else
            {
                //Get throught zonelist
                for (int i = zones.Count - 1; i >= 0; i--)
                {
                    //Compare IDtask with CurrPlayer.CurrIDTask
                    if ((zones[i] as ZoneEvent).idTask == idTask)
                    {
                        ReturnValue = (zones[i] as ZoneEvent).commandLeave;
                    }
                }
            }
            return ReturnValue;
        }
        
        //New 09/12/2016
        public string getCommandIDTask(string trackName, int idx)
        {
            ArrayList zones = (ArrayList)listOfZones[trackName];
            return (zones[idx] as ZoneEvent).idTask;
        }
    }
}
